10    !  7912 HB/ HP 9000 Series 200/300
20    !
30    ! Waveform acquire, scale, and graph
40    ! scaled waveform program.
50    !
60    ! Written on 9826 w/ Ver 4.0 BASIC.
70    ! using GPIB port 7.
80    !
90    !  Requires loading the following binary
100   !  files before executing:
110   !
120   ! TYPE: LOAD BIN "<FILENAME>"
130   ! WHERE <FILENAME>=IO,GRAPH,& MAT
140   !
150   !  o- IO      Opt 4
160   !  o- GRAPH   Opt 2
170   !  o- MAT     Opt 7
180   !
190   CALL Drawlogo
200   GOSUB Initialize
210   ON INTR 7 CALL Srqhandl
220   ENABLE INTR 7;2
230   CALL Getscale(@Dig,Xi,Ym)
240   INTEGER Iwfm(1:512)
250   DIM Wfm(1:512)
260   PRINT "READING 512 POINT WAVEFORM"
270   CALL Getwfm(@Dig,Iwfm(*))
280   OUTPUT @Dig;"MODE TV" !BACK TO TV MODE
290   CALL Scalewfm(Ym,Yz,Wfm(*),Iwfm(*))
300   CALL Graphwfm(Wfm(*),Xi)
310   CALL Getans("Acquire another waveform",Ans$)
320   IF Ans$="Y" THEN GOTO 230
330   GOTO Fini
340 Initialize:   !
350   ABORT 7
360   REMOTE 70000
370   CLEAR 70000
380   ASSIGN @Dig TO 70000;EOL CHR$(13) END
390   ASSIGN @Vert TO 70001;EOL CHR$(13) END
400   ASSIGN @Tb TO 70002;EOL CHR$(13) END
410   !
420   ! THE NEXT LINE TELLS THE 7912HB TO
430   ! DIGITIZER ANY DEFECTS IN THE SCAN
440   ! CONVERTER AND REMOVE THEM FROM ANY
450   ! SUBSEQUENT ACQUISITIONS
460   !
470   PRINT "REMOVING ANY DEFECTS IN 7912HB CRT"
480   OUTPUT @Dig;"DIG DEF,128;DEF ON"
490   !
500   ! THE NEXT LINE TELLS THE 7912HB TO
510   ! DISPLAY THE ATC WAVEFORM ON THE X-Y
520   ! MONITOR
530   !
540   OUTPUT @Dig;"XYZ ATC"
550   !
560   ! THE NEXT LINE SETS VARIABLE 'YZ' TO -1
570   ! IF THERE HASN'T BEEN A GROUND REFERENCE
580   ! ACQUIRED.  IF THE USER ENTERS Yes TO THE
590   ! NEXT QUESTION, YZERO 'YZ' IS SET TO A
600   ! NUMBER BETWEEN 0 AND 511
610   !
620   Yz=-1
630   CALL Getans("Reference wfm to ground",Ans$)
640   IF Ans$<>"Y" THEN RETURN 
650   !
660   ! THE NEXT SECTION OF CODE DETERMINES
670   ! THE COUPLING OF THE 7A29P/7A16P INPUT
680   ! AND THE TRIGGER MODE OF THE 7B90P AND
690   ! READS THEM INTO A STRING.  IT THEN
700   ! GROUNDS THE VERTICAL AMP & SETS THE
710   ! TIMEBASE TO P-P AUTO TO ACQUIRE A
720   ! GROUND TRACE.
730   !
740   PRINT "READING GROUND REFERENCE"
750   OUTPUT @Vert;"CPL?"
760   ENTER @Vert;Cpl$
770   OUTPUT @Tb;"MOD?"
780   ENTER @Tb;Mod$
790   OUTPUT @Vert;"CPL GND"
800   OUTPUT @Tb;"MOD PPA"
810   WAIT .5! ALLOW CRT TO CAPTURE GND REF
820   !
830   ! THE SECTION OF CODE ACQUIRES THE GROUND
840   ! TRACE AND TAKES THE MEAN VALUE OF THE
850   ! FIRST 20 POINTS.  IT THEN RESETS THE
860   ! VERTICAL & TIMEBASE PLUG-INS TO THE
870   ! ORIGINAL STATE.
880   !
890   CALL Getwfm(@Dig,Iwfm(*))
900   Tmp=0
910   FOR I=20 TO 40
920   Tmp=Tmp+Iwfm(I)
930   NEXT I
940   Yz=Tmp/20
950   OUTPUT @Vert;Cpl$ !RESET VERTICAL COUPLING
960   OUTPUT @Tb;Mod$!RESET TIMEBASE TRIGGER
970   WAIT .5 !ALLOW CRT TO CAPTURE SIGNAL
980   RETURN 
990 Fini:   PRINT "7912HB PROGRAM TERMINATED"
1000        END
1010  SUB Getscale(@Dig,Xi,Ym)
1020  REM 
1030  REM GET SCALE FACTORS FOR 7912HB WAVEFORM
1040  REM 
1050  PRINT "READING SCALE FACTORS"
1060  OUTPUT @Dig;"VS1?"
1070  ENTER @Dig;Nul,Vs
1080  Ym=Vs/64 !64 LEVELS PER DIVSION
1090  Ym=Ym/2 !MUST DIVIDE BY 2 FOR ATC WAVEFORM
1100  OUTPUT @Dig;"HS1?"
1110  ENTER @Dig;Nul,Hs
1120  Xi=Hs/51.2 !51.2 POINTS PER DIVISION
1130  SUBEND
1140 SUB Getwfm(@Dig,INTEGER Iwfm(*))
1150 REM 
1160 REM GET A WAVEFORM FROM 7912HB
1170 REM AND RETURN IT IN THE INTEGER ARRAY 'IWFM'
1180 !
1190 ! THE NEXT LINE SETS UP THE 7912HB TO GO
1200 ! INTO DIGITAL MODE, PERFORM ATC (AVERAGE
1210 ! TO CENTER TRACE) AND GET READY TO SEND
1220 ! THE DATA TO THE CONTROLLER.  YOU MAY WANT
1230 ! TO CHANGE THIS LINE FOR YOUR PARTICAULAR
1240 ! NEEDS.
1250 !
1260 OUTPUT @Dig;"MODE DIG;DIG DAT;ATC;READ ATC"
1270 !
1280 ! THEN NEXT LINE READS THE FIRST 3 BYTES
1290 ! OF THE CURVE DATA %<byte cnt><byte cnt>
1300 !
1310 ENTER @Dig USING "#,3A";Cur$ !READ % SIGN
1320 !
1330 ! THE NEXT LINE READS THE 512 POINT INTEGER
1340 ! WAVEFORM, USING TWO BYTES PER DATA POINT
1350 ! AND PACKS THEM INTO ONE BYTE (USING THE
1360 ! "%,W" CLAUSE.
1370 !
1380 ENTER @Dig USING "%,W";Iwfm(*)
1390 ENTER @Dig USING "B";Chksum,Semicolon
1400 SUBEND
1410 SUB Scalewfm(Ym,Yz,Wfm(*),INTEGER Iwfm(*))
1420 REM 
1430 REM SCALE BINARY WAVEFORM STORED IN 'IWFM'
1440 REM INTO A VOLTAGE WAVEFORM STORED IN 'WFM'
1450 REM 
1460 PRINT "SCALING INTO VOLTAGE WAVEFORM"
1470 IF Yz>-1 THEN MAT Iwfm= Iwfm-(Yz)
1480 MAT Wfm= Iwfm*(Ym)
1490 SUBEND
1500 SUB Graphwfm(Wfm(*),Xi)
1510 Np=512
1520 GINIT
1530 GCLEAR
1540 GRAPHICS ON
1550 Amax=MAX(Wfm(*))
1560 Amin=MIN(Wfm(*))
1570 Peak=Amax-Amin
1580 Voffset=(Amax-Amin)/20
1590 Hoffset=(Np)/20
1600 OUTPUT 2;"K"; ! Clears dialog area
1610 ! Message between quotes is as follows:
1620 ! "<CTRL-BACKSPACE>K"
1630 MOVE 40,90
1640 LABEL "7912HB WAVEFORM"
1650 MOVE 0,85
1660 LABEL USING "5A,3D.2D,8A,3D.2D,8A,3D.2D,1A";"MAX=",Amax,"V, MIN=",Amin,"V, 
PEAK=",Peak,"V"
1670 VIEWPORT 20,110,20,80
1680 WINDOW 0,(Np)+Hoffset,Amin-Voffset,Amax+Voffset
1690 LINE TYPE 1
1700 MOVE 0,Amin-Voffset
1710 DRAW Np+Hoffset,Amin-Voffset
1720 DRAW Np+Hoffset,Amax+Voffset
1730 DRAW 0,Amax+Voffset
1740 DRAW 0,Amin-Voffset
1750 MOVE 0+Hoffset/2,Wfm(1)+Voffset/2
1760 FOR I=2 TO 512
1770 DRAW I+Hoffset/2,Wfm(I)+Voffset/2
1780 NEXT I
1790 IF Amin>0 OR Amax<0 THEN GOTO 1880
1800 IF Yz=-1 THEN GOTO 1880
1810 !
1820 ! DRAW GROUND REFERENCE LINE
1830 !
1840 LINE TYPE 4
1850 MOVE 0+Hoffset/2,0+Voffset/2
1860 DRAW Np+Hoffset/2,0+Voffset/2
1870 LINE TYPE 1
1880 WINDOW 0,100,0,100
1890 VIEWPORT 0,100,0,100
1900 MOVE 0,10
1910 LABEL "<ENTER> TO CONTINUE:";
1920 INPUT A$
1930 GCLEAR
1940 SUBEND
1950 SUB Srqhandl
1960 Sb=SPOLL(70000)
1970 Sbv=SPOLL(70001)
1980 Sbt=SPOLL(70002)
1990 IF Sb<16 THEN 2040
2000 BEEP 
2010 PRINT "SRQ...Mainframe Status=";Sb
2020 PRINT "SRQ...Vertical Status=";Sbv
2030 PRINT "SRQ...Timebase Status=";Sbt
2040 ENABLE INTR 7;2
2050 SUBEND
2060  SUB Drawlogo
2070     GINIT
2080 OUTPUT 2;"K"; ! Clears dialog area
2090     GCLEAR
2100     GRAPHICS ON
2110   !
2120     VIEWPORT 5*RATIO,95*RATIO,30,90
2130     FRAME
2140     VIEWPORT 6*RATIO,94*RATIO,31,89
2150     FRAME
2160     WINDOW 0,1000,0,1000
2170   !
2180     LORG 4
2190     CSIZE 20,.5
2200   !
2210     FOR I=0 TO 8 STEP .5
2220         MOVE 500+I,600+I
2230         LABEL "Tektronix"
2240     NEXT I
2250   !
2260     LORG 6
2270     CSIZE 15,.5
2280   !
2290     FOR I=0 TO 8 STEP .5
2300         MOVE 480+I,595+I
2310         LABEL "7912 HB"
2320     NEXT I
2330   !
2340   FOR I=0 TO 8 STEP .5
2350   MOVE 490+I,350+I
2360   LABEL "ACQUIRE/GRAPH"
2370   NEXT I
2380   CSIZE 5,.5
2390     MOVE 490,100
2400     LABEL "PRESS <ENTER> TO ACQUIRE WAVEFORM"
2410     INPUT A$
2420     GCLEAR
2430     SUBEND
2440  SUB Getans(Mes$,Ans$)
2450  PRINT Mes$&"? (Y/N):"
2460  INPUT Ans$
2470  IF Ans$="Y" OR Ans$="y" THEN Ans$="Y"
2480  SUBEND

